/******************************************************************************
 * Technical University of Darmstadt
 * Industrial Process and System Communication
 * Project: TCP
 * Filename: FSMStatePanel.java
 * Contents: Loads images and places these images in a panel
 *****************************************************************************/

import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Graphics;
import java.awt.Event;
import java.awt.Color;
import java.awt.Label;

/******************************************************************************
* Class: FSMStatePanel
* Description: places the TCP-Status in a panel
******************************************************************************/
public class FSMStatePanel extends Panel {
  Image image;
  String statestring;
  int size, dx, dy, dx1;
  int highlight;
  boolean exist_bool=false;
  Label label1;
  FSMWindow fsm_window;

  public FSMStatePanel ( FSMWindow fsm_window, int status, int highlight){
    this .fsm_window=fsm_window;
    this .highlight = highlight;
    changeSize( fsm_window, status, highlight );
    setLayout( null );
    setBackground(Color.lightGray);
    validate();
    show();
  }

/******************************************************************************
* Method: paint
* Description: draws the image.
* Parameters: the used graphic
* Return Value: none
******************************************************************************/
  public void paint( Graphics g ){
    g. drawString( statestring, 5, 14 );
  }

/******************************************************************************
* Method: update
* Description:
* Parameters: the used graphic
* Return Value: none
******************************************************************************/
  public void update( Graphics g ){
    paint( g );
  }

/******************************************************************************
* Method: changeSize
* Description: scales the images and paints them
* Parameters: quality factor
* Return Value: none
******************************************************************************/
  public void changeSize( FSMWindow fsm_window, int status, int highlight ){

    this .size = fsm_window.screenfactor;
    if (highlight == 0) setBackground(Color.lightGray);
    if (highlight == 1) setBackground(Color.red);
    if (highlight == 2) setBackground(Color.yellow);
    switch (status) {
        case 0:
            statestring = "CLOSED";
	    if (highlight == 0) exist_bool = false;
	    else exist_bool = true;  
            break;
        case 1:
            statestring = "LISTEN";
            break;
        case 2:
            statestring = "SYN_SENT";
            break;
        case 3:
            statestring = "SYN_RCVD";
            break;
        case 4:
            statestring = "ESTABLISHED";
	    if (highlight == 0) exist_bool = false;
	    else exist_bool = true;  
            break;
        case 5:
            statestring = "CLOSE_WAIT";
            break;
        case 6:
            statestring = "LAST_ACK";
            break;
        case 7:
            statestring = "FIN_WAIT_1";
            break;
        case 8:
            statestring = "FIN_WAIT_2";
            break;
        case 9:
            statestring = "CLOSING";
            break;
        case 10:
            statestring = "TIME_WAIT";
            break;
        case 11:
            statestring = "Host 1";
            break;
        case 12:
            statestring = "Host 2";
            break;
        case 13:
            statestring = "Client";
            break;
        case 14:
            statestring = "Server";
            break;
        default:
            statestring = "";
    }
    //validate();
    changeSize(size);
  }
/******************************************************************************
* Method: changeSize
* Description: scales the Stringfield and paints them
* Parameters: screenfactor
* Return Value: none
******************************************************************************/
  public void changeSize( int size ){
    if( size == 1 ){
      dx = 100;  //factor 1
      dy = 20;
    }
    else if( size == 2 ){
      dx = 120;  //factor 1,25
      dy = 24;
    }
    else if( size == 3 ){
      dx = 160;  //factor 1,6
      dy = 32;
    }
    else if( size == 4 ){
      dx = 200;  //factor 2
      dy = 40;
    }
    if( !exist_bool ){
      dx = dx-3;
      dy = dy-3;
    }
    resize( dx, dy );
    repaint();
    validate();
    show();
  }
}












